//************************************************************************************************
//Ra2.cpp
//Fait par: Francois-Gabriel Auclair aka TheKGBspy
//section pour les scripts principalement utiliss par le mod Ra2:vengeance
//derniere modification: 5 avril 2004
//e-mail: Boris_the_invincible@hotmail.com
//e-mail2: TheKGBspy@timeofwar.com
//************************************************************************************************

#include "scripts.h"
#include "Ra2.h"

//************************************************************************************************
//Script pour le mirage tank
//************************************************************************************************
void Ra2Ven_MirageTank::Created(GameObject * obj)
{
	pilotID = 0;
	xpos = 0;
	ypos = 0;
	zpos = 0;
	IsHided = false;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));

}

//**********************
void Ra2Ven_MirageTank::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 TreeExplo;
	TreeExplo = Commands->Get_Bone_Position(obj,"origin");
	Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),TreeExplo,0);
}

//**********************
void Ra2Ven_MirageTank::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
	Auto_Save_Variable(5,1,&IsHided);
}

//**********************
void Ra2Ven_MirageTank::Timer_Expired(GameObject * obj,int number)
{

	const char* preset;
	int rand;
	GameObject *tree;
	Vector3 TreePos;
	Vector3 TreeExplo;
	
	Vector3 position = Commands->Get_Position(obj);
	if ((xpos == 0) && (ypos == 0) && (zpos == 0))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
	}
	
	if (pilotID != 0)
	{
		if ((fabs(position.X-xpos) <= .5) && (fabs(position.Y-ypos) <= .5) && (fabs(position.Z-zpos) <= .5))
		{
			if (IsHided == false)
			{
			
			//random pis attach dun abre
			
			preset = "none";

			while (stricmp(preset, "none") == 0)
			{
				rand = Commands->Get_Random_Int(1,5);
				switch(rand)
				{
					case 1:
						preset = Get_Parameter("Tree1_Preset");
						break;
					case 2:
						preset = Get_Parameter("Tree2_Preset");
						break;
					case 3:
						preset = Get_Parameter("Tree3_Preset");
						break;
					case 4:
						preset = Get_Parameter("Tree4_Preset");
						break;
				}
			}
			TreePos.X = 0;
			TreePos.Y = 0;
			TreePos.Z = 0;
			tree = Commands->Create_Object(preset,TreePos);
			//Commands->Disable_Physical_Collisions(tree);
			Commands->Attach_To_Object_Bone(tree,obj,"origin");
			Commands->Set_Is_Rendered(obj,false);
			IsHided = true;
			}
		}
		else
		{
			xpos = position.X;
			ypos = position.Y;
			zpos = position.Z;
			if (IsHided == true)
			{
				Commands->Set_Is_Rendered(obj,true);
				IsHided = false;
				TreeExplo = Commands->Get_Bone_Position(obj,"origin");
				Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),TreeExplo,0);
			}
		}
		
	}
	else
	{
		if (IsHided == true)
		{
			Commands->Set_Is_Rendered(obj,true);
			IsHided = false;
			TreeExplo = Commands->Get_Bone_Position(obj,"origin");
			Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),TreeExplo,0);
		}

	}

	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_MirageTank::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}


//************************************************************************************************
//Script de dommage par rapport au temp tomber.
//************************************************************************************************
void Ra2Ven_VehicleFalling::Created(GameObject * obj)
{
	IsFalling = false;
	xpos = 0;
	ypos = 0;
	zpos = 0;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_VehicleFalling::Timer_Expired(GameObject *obj, int number)
{
	Vector3 position = Commands->Get_Position(obj);
	const char* warh;
	double calcul;
	int convert;
	float dom;

	if ((xpos == 0) && (ypos == 0) && (zpos == 0))
	{
		xpos = position.X;
		ypos = position.Y;
		zpos = position.Z;
	}

	if ((position.Z-zpos) > Get_Int_Parameter("ZValueBeforeStartFallingMode"))
	{
		IsFalling = true;
	}
	else //pas entrain de tomber...
	{
		if (IsFalling == true)
		{
			Vector3 ExplosionSound;
			calcul = (fabs(zpos-position.Z)/2.5)*Get_Int_Parameter("DommageMultiplier");//calcul
			convert = (int)calcul;
			dom = (float)convert;
			warh = Get_Parameter("Warhead");
			ExplosionSound = Commands->Get_Bone_Position(obj,"origin");
			Commands->Create_Explosion(Get_Parameter("ImpactExplosion_Preset"),ExplosionSound,0);
			Commands->Apply_Damage(obj,dom,warh,0);
			IsFalling = false;
		}

		zpos = position.Z;

	}
	
	
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_VehicleFalling::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&IsFalling);
	Auto_Save_Variable(2,4,&xpos);
	Auto_Save_Variable(3,4,&ypos);
	Auto_Save_Variable(4,4,&zpos);
}

//************************************************************************************************
//Script pour demo truck contre le bug du friendly fire pis le double nuke
//************************************************************************************************

void Ra2Ven_DemoTruck::Created(GameObject *obj)
{
	pilotID = 0;
	CanExplode = true;
}

//**********************
void Ra2Ven_DemoTruck::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}

//**********************
void Ra2Ven_DemoTruck::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	if ((damager == Commands->Find_Object(pilotID)) && (damager != NULL))
	{
		CanExplode = false;
		Commands->Apply_Damage(obj,Get_Float_Parameter("FFFDommage"),Get_Parameter("FFFWh"),0);
	}
}

//**********************
void Ra2Ven_DemoTruck::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
	Auto_Save_Variable(2,1,&CanExplode);
}

//**********************
void Ra2Ven_DemoTruck::Killed(GameObject * obj,GameObject * shooter)
{
	if (CanExplode == true)
	{
		Vector3 DemoCharge;
		DemoCharge = Commands->Get_Bone_Position(obj,"origin");
		Commands->Create_Explosion(Get_Parameter("Demo_Explosion"),DemoCharge,0);
	}
}

//************************************************************************************************
//Deployable vehicles
//************************************************************************************************
void Ra2Ven_Deployable_Vehicle::Created(GameObject * obj)
{
	pilotID = 0;
	CanDestroyAnim = true;
}

//**********************
void Ra2Ven_Deployable_Vehicle::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(pilotID == 0)
		{
			pilotID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(pilotID == Commands->Get_ID(sender))
		{
			pilotID = 0;
		}
	}
}

//**********************
void Ra2Ven_Deployable_Vehicle::Damaged(GameObject * obj,GameObject * damager,float damage)
{
	GameObject * Animation;
	Vector3 position;
	int TempCalcul;


	if ((damager == Commands->Find_Object(pilotID)) && (damager != NULL))
	{
		position.X = 0;
		position.Y = 0;
		position.Z = 0;
		Animation = Commands->Create_Object(Get_Parameter("Animation_Preset"),position);

		TempCalcul = (int)(Commands->Get_Max_Health(Animation) * (Commands->Get_Health(obj)/Commands->Get_Max_Health(obj)));
		Commands->Set_Health(Animation,(float)TempCalcul);
			
		TempCalcul = (int)(Commands->Get_Max_Shield_Strength(Animation) * (Commands->Get_Shield_Strength(obj)/Commands->Get_Max_Shield_Strength(obj)));
		Commands->Set_Shield_Strength(Animation,(float)TempCalcul);
	

		Commands->Attach_To_Object_Bone(Animation,obj,"origin");

		CanDestroyAnim = false;
		Commands->Apply_Damage(obj,Get_Float_Parameter("oldTnk_Dommage"),Get_Parameter("oldTnk_Wh"),0);//kill the old tank

	}
}

//**********************
void Ra2Ven_Deployable_Vehicle::Killed(GameObject * obj,GameObject * shooter)
{
	Vector3 position;

	if (CanDestroyAnim == true)
	{
		position = Commands->Get_Bone_Position(obj,"origin");
		Commands->Create_Explosion(Get_Parameter("Explosion_preset"),position,0);

	}
}

//**********************
void Ra2Ven_Deployable_Vehicle::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&pilotID);
	Auto_Save_Variable(2,4,&pilotID);

}

//************************************************************************************************
//Deploy animation
//************************************************************************************************
void Ra2Ven_Deploy_Animation::Created(GameObject * obj)
{
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Animation_Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_Deploy_Animation::Timer_Expired(GameObject * obj,int number)
{
	GameObject * DeployedTnk;
	Vector3 position;
	int TempCalcul;

	position.X = 0;
	position.Y = 0;
	position.Z = 0;
	DeployedTnk = Commands->Create_Object(Get_Parameter("Deployed_Tank_Preset"),position);

	TempCalcul = (int)(Commands->Get_Max_Health(DeployedTnk) * (Commands->Get_Health(obj)/Commands->Get_Max_Health(obj)));
	Commands->Set_Health(DeployedTnk,(float)TempCalcul);
			
	TempCalcul = (int)(Commands->Get_Max_Shield_Strength(DeployedTnk) * (Commands->Get_Shield_Strength(obj)/Commands->Get_Max_Shield_Strength(obj)));
	Commands->Set_Shield_Strength(DeployedTnk,(float)TempCalcul);

	Commands->Attach_To_Object_Bone(DeployedTnk,obj,"origin");
	Commands->Apply_Damage(obj,Get_Float_Parameter("oldTnk_Dommage"),Get_Parameter("oldTnk_Wh"),0);//kill the old tank
}

//***********************************************************************************************
void Ra2Ven_RandomTree::Created(GameObject *obj)
{
	const char* preset;
	int rand;
	GameObject *tree;
	Vector3 TreePos;


	preset = "none";

	rand = Commands->Get_Random_Int(1,6);
	switch(rand)
	{
		case 1:
			preset = Get_Parameter("Tree1_Preset");
			break;
		case 2:
			preset = Get_Parameter("Tree2_Preset");
			break;
		case 3:
			preset = Get_Parameter("Tree3_Preset");
			break;
		case 4:
			preset = Get_Parameter("Tree4_Preset");
			break;
		case 5:
			preset = "none";
			break;
	}

	if (stricmp(preset, "none") != 0)
	{
		TreePos.X = 0;
		TreePos.Y = 0;
		TreePos.Z = 0;
		tree = Commands->Create_Object(preset,TreePos);
		Commands->Attach_To_Object_Bone(tree,obj,"origin");
	}
				
}

//***********************************************************************************************
void Ra2Ven_TurretSound::Created(GameObject *obj)
{
	GameObject *TurretObj;
	Vector3 TurPos;

	TurPos.X = 0;
	TurPos.Y = 0;
	TurPos.Z = 0;
	TurretObj = Commands->Create_Object(Get_Parameter("TurretSoundObj"),TurPos);
	Commands->Attach_To_Object_Bone(TurretObj,obj,"turret");
	TurretId = Commands->Get_ID(TurretObj);
}

//**********************
void Ra2Ven_TurretSound::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Send_Custom_Event(obj,Commands->Find_Object(TurretId),201,0,0);
}

//**********************
void Ra2Ven_TurretSound::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&TurretId);
}

//***********************************************************************************************
void Ra2Ven_TurretSoundObj::Created(GameObject *obj)
{
	int MyFacing;

	if ((int)Commands->Get_Facing(obj) <= 0)
	{
		MyFacing = (int)Commands->Get_Facing(obj) + 360;
	}
	else
	{
		MyFacing = (int)Commands->Get_Facing(obj);
	}
	
	LastOrientation = MyFacing;
	CanPlay = true;
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_TurretSoundObj::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == 201)
	{
		Vector3 TurExplo;
		TurExplo = Commands->Get_Position(obj);
		Commands->Create_Explosion(Get_Parameter("Explosion_Preset"),TurExplo,0);
	}
}

//**********************
void Ra2Ven_TurretSoundObj::Timer_Expired(GameObject * obj,int number)
{
	if (number == Get_Int_Parameter("TimerNumber"))
	{ 
		int MyFacing;

		if ((int)Commands->Get_Facing(obj) <= 0)
		{
			MyFacing = (int)Commands->Get_Facing(obj) + 360;
		}
		else
		{
			MyFacing = (int)Commands->Get_Facing(obj);
		}
	
		if (MyFacing != LastOrientation)
		{
			LastOrientation = MyFacing;
			if (CanPlay == true)
			{
				Commands->Create_3D_Sound_At_Bone(Get_Parameter("Rotate_3dSound"),obj,"turret");//
				CanPlay = false;
				Commands->Start_Timer(obj,this,Get_Float_Parameter("Wav_Length"),Get_Int_Parameter("TimerNumber2"));
			}
		}
	}
	else if (number == Get_Int_Parameter("TimerNumber2"))
	{ 
		CanPlay = true;
	}
	
	Commands->Start_Timer(obj,this,Get_Float_Parameter("Time"),Get_Int_Parameter("TimerNumber"));
}

//**********************
void Ra2Ven_TurretSoundObj::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&LastOrientation);
	Auto_Save_Variable(2,1,&CanPlay);
}

//***********************************************************************************************
void Ra2Ven_OccupentWeapon::Custom(GameObject * obj,int message,int param,GameObject * sender)
{
	if (message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if (stricmp(Commands->Get_Preset_Name(sender),Get_Parameter("Character1")) == 0)
		{
			Commands->Clear_Weapons(obj);
			Commands->Give_Powerup(obj, Get_Parameter("PowerUp1"),1);
			Commands->Select_Weapon(obj, Get_Parameter("Weapon1"));
		}
		else if (stricmp(Commands->Get_Preset_Name(sender),Get_Parameter("Character2")) == 0)
		{
			Commands->Clear_Weapons(obj);
			Commands->Give_Powerup(obj, Get_Parameter("PowerUp2"),1);
			Commands->Select_Weapon(obj, Get_Parameter("Weapon2"));
		}
		else if (stricmp(Commands->Get_Preset_Name(sender),Get_Parameter("Character3")) == 0)
		{
			Commands->Clear_Weapons(obj);
			Commands->Give_Powerup(obj, Get_Parameter("PowerUp3"),1);
			Commands->Select_Weapon(obj, Get_Parameter("Weapon3"));
		}
		else if (stricmp(Commands->Get_Preset_Name(sender),Get_Parameter("Character4")) == 0)
		{
			Commands->Clear_Weapons(obj);
			Commands->Give_Powerup(obj, Get_Parameter("PowerUp4"),1);
			Commands->Select_Weapon(obj, Get_Parameter("Weapon4"));
		}
		else 
		{
			Commands->Clear_Weapons(obj);
			Commands->Give_Powerup(obj, Get_Parameter("DefPowerUp"),1);
			Commands->Select_Weapon(obj, Get_Parameter("DefWeapon"));
		}


	}
}

//************************************************************************************************
//Registrant des scripts
//************************************************************************************************
ScriptRegistrant<Ra2Ven_MirageTank> Ra2Ven_MirageTank_Registrant ("Ra2Ven_MirageTank","Tree1_Preset:string,Tree2_Preset=none:string,Tree3_Preset=none:string,Tree4_Preset=none:string,Explosion_Preset:string,Time=1:float,TimerNumber:int");
ScriptRegistrant<Ra2Ven_VehicleFalling> Ra2Ven_VehicleFalling_Registrant ("Ra2Ven_VehicleFalling","ZValueBeforeStartFallingMode:int=3,ImpactExplosion_Preset:string,Warhead:string,DommageMultiplier=10:int,Time=1:float,TimerNumber:int");
ScriptRegistrant<Ra2Ven_DemoTruck> Ra2Ven_DemoTruck_Registrant ("Ra2Ven_DemoTruck","FFFDommage:float,FFFWh:string,Demo_Explosion:string");
ScriptRegistrant<Ra2Ven_Deployable_Vehicle> Ra2Ven_Deployable_Vehicle_Registrant ("Ra2Ven_Deployable_Vehicle","Animation_Preset:string,oldTnk_Wh:string,oldTnk_Dommage:float,Explosion_preset:string");
ScriptRegistrant<Ra2Ven_Deploy_Animation> Ra2Ven_Deploy_Animation_Registrant ("Ra2Ven_Deploy_Animation","Deployed_Tank_Preset:string,oldTnk_Wh:string,oldTnk_Dommage:float,Animation_Time:float,TimerNumber:int");
ScriptRegistrant<Ra2Ven_RandomTree> Ra2Ven_RandomTree_Registrant ("Ra2Ven_RandomTree","Tree1_Preset:string,Tree2_Preset=none:string,Tree3_Preset=none:string,Tree4_Preset=none:string");
ScriptRegistrant<Ra2Ven_TurretSound> Ra2Ven_TurretSound_Registrant ("Ra2Ven_TurretSound","TurretSoundObj:string");
ScriptRegistrant<Ra2Ven_TurretSoundObj> Ra2Ven_TurretSoundObj_Registrant ("Ra2Ven_TurretSoundObj","RotationAngleLimit:int,Rotate_3dSound:string,Explosion_Preset:string,Time=0.5:float,TimerNumber:int,Wav_Length:float,TimerNumber2:int");
ScriptRegistrant<Ra2Ven_OccupentWeapon> Ra2Ven_OccupentWeapon_Registrant ("Ra2Ven_OccupentWeapon","Character1:string,PowerUp1:string,Weapon1:string,Character2:string,PowerUp2:string,Weapon2:string,Character3:string,PowerUp3:string,Weapon3:string,Character4:string,PowerUp4:string,Weapon4:string,DefPowerUp:string,DefWeapon:string");

//***********************
